set markup html on spool on
spool 20121109_dbpm.html

REM ****************************************************************************
REM * Name: dbpm.sql                                                           *
REM * Modifier : shahn                                                         *
REM * Modified at : 2010-02-02                                                 *
REM ****************************************************************************

REM host export LOGDATE=`date +%Y%m%d`
REM SPOOL dbpm.rpt

SET LINESIZE 150
SET PAGESIZE 5000

COLUMN name1 new_value yyyymm NOPRINT 
COLUMN name2 new_value thread NOPRINT

SELECT TO_CHAR(SYSDATE,'yyyymm') name1
      ,thread# name2
FROM v$instance
/

COLUMN dbname   NEW_VALUE dbname
COLUMN now      NEW_VALUE today 
COLUMN month    NEW_VALUE month 
COLUMN instance NEW_VALUE instance
COLUMN thread   NEW_VALUE thread_number

SELECT b.thread# thread
      ,b.instance_name instance
      ,a.name dbname
      ,a.log_mode
      ,b.host_name
      ,a.platform_name
      ,b.version
      ,b.parallel
--      ,b.archiver
--      ,TO_CHAR(SYSDATE,'YYYY-MM-DD') now
--      ,TO_CHAR(SYSDATE,'YYYY-MM') month
      ,a.log_mode
FROM v$database a
    ,v$instance b
/

show sga
prompt
prompt
archive log list


PROMPT
PROMPT
PROMPT *******************************************
PROMPT * 1. SGA Configuration                    *
PROMPT *    1.1 Shared Pool Size                 *
PROMPT *    1.2 DB Cache Size                    *
PROMPT *    1.3 Redo Buffer Size                 *
PROMPT *******************************************



PROMPT
PROMPT 1.1 Shared Pool Size (bytes)
PROMPT ***************************************************************

COLUMN name	FORMAT a15		HEADING 'Name'
COLUMN pool	FORMAT a15		HEADING 'Pool Name'
COLUMN tbytes	FORMAT 999,999,999,999	HEADING 'Total Size'
COLUMN ubytes	FORMAT 999,999,999,999	HEADING 'Used Size'
COLUMN usedp    FORMAT a8	   	HEADING 'Used(%)'
COLUMN fbytes	FORMAT 999,999,999,999	HEADING 'Free Size'
COLUMN freep    FORMAT a8	   	HEADING 'Free(%)'

SELECT pool
      ,SUM(bytes) AS tbytes
FROM v$sgastat
WHERE pool='shared pool'
GROUP BY pool
/

SELECT a.pool AS pool
      ,(a.tbytes-b.fbytes) AS ubytes
      ,ROUND((((a.tbytes-b.fbytes)/a.tbytes)*100),2)||'%' AS usedp
FROM (SELECT pool
            ,SUM(bytes) AS tbytes
      FROM v$sgastat
      WHERE pool='shared pool'
      GROUP BY pool) a
    ,(SELECT pool
            ,bytes AS fbytes
      FROM v$sgastat
      WHERE pool='shared pool'
      AND name='free memory') b
WHERE a.pool='shared pool'
/

SELECT a.pool AS pool
      ,a.name AS name
      ,a.bytes AS fbytes
      ,ROUND(((a.bytes/b.tbytes)*100),2)||'%' AS freep
FROM v$sgastat a
,(SELECT SUM(bytes) AS tbytes
      FROM v$sgastat
      WHERE pool='shared pool') b
WHERE pool='shared pool'
AND name='free memory'
/

PROMPT
PROMPT 1.2 Database Cache Size (bytes)
PROMPT ***************************************************************

COLUMN name	FORMAT a15		HEADING 'Name'
COLUMN tbytes	FORMAT 999,999,999,999	HEADING 'Total Size'
COLUMN ubytes	FORMAT 999,999,999,999	HEADING 'Used Size'
COLUMN fbytes	FORMAT 999,999,999,999	HEADING 'Free Size'
COLUMN ct	FORMAT 999,999,999,999	HEADING 'Data Buffers'
COLUMN usedp    FORMAT a8   		HEADING 'Used(%)'
COLUMN freep    FORMAT a8   		HEADING 'Free(%)'

SELECT a.name AS name
      ,SUM(a.bytes) AS tbytes
      ,SUM(b.ubytes) AS ubytes
      ,SUM(a.bytes-b.ubytes) AS fbytes
      ,ROUND(SUM(b.ubytes)/SUM(a.bytes)*100,2)||'%' AS usedp
      ,ROUND(SUM((a.bytes-b.ubytes)/a.bytes)*100,2)||'%' AS freep
FROM v$sgastat a
    ,(SELECT COUNT(1)*8192 AS ubytes
      FROM v$bh) b
WHERE a.name='buffer_cache'
GROUP BY a.name
/

REM ----------------------------------------------------------------------------
REM In ORACLE 8
REM ----------------------------------------------------------------------------

--COLUMN name	FORMAT a20		HEADING 'Name'
--COLUMN tbytes	FORMAT 999,999,999,999	HEADING 'Total Size'
--
--SELECT name, bytes as tbytes
--FROM v$sgastat
--WHERE name = 'db_block_buffers' and pool is null
--/

PROMPT
PROMPT 1.3 Redo Buffer Size (bytes)
PROMPT ***************************************************************

COLUMN name		FORMAT a15							HEADING 'Buffer Name'
COLUMN bytes	FORMAT 999,999,999,999	HEADING 'Size'

SELECT name
      ,SUM(bytes) AS bytes
FROM v$sgastat
WHERE name='log_buffer'
GROUP BY name
/

PROMPT
PROMPT
PROMPT *******************************************
PROMPT * 2. Memory Allocation                    *
PROMPT *    2.1 Library Cache Miss Ratio         *
PROMPT *    2.2 Data Dictionary Miss Ratio       *
PROMPT *    2.3 Buffer Cache Hit Ratio           *
PROMPT *******************************************

PROMPT
PROMPT 2.1 Library Cache Miss Ratio
PROMPT ***************************************************************

COLUMN missratio	FORMAT a40		HEADING 'Library Cache Miss Ratio|(If>1%, increase SHARED_POOL_SIZE)'

SELECT TRUNC(((SUM(reloads)/SUM(pins))*100),2)||'%' AS missratio
--      ,SUM(pins) AS executions
--      ,SUM(reloads) AS reloads
FROM v$librarycache
/

PROMPT
PROMPT 2.2 Data Dictionary Cache Hit Ratio and Miss Ratio
PROMPT ***************************************************************

COLUMN missratio	FORMAT a40		HEADING 'Data Dictionary Cache Miss Ratio|(If>9.8%, increase SHARED_POOL_SIZE)'
COLUMN hitratio   	FORMAT a40		HEADING 'Data Dictionary Cache Hit Ratio|(If<90%, increase SHARED_POOL_SIZE)'

SELECT TRUNC((SUM(getmisses)/SUM(gets))*100,2)||'%' AS missratio
      ,TRUNC((1-(SUM(getmisses)/SUM(gets)))*100,2)||'%' AS hitratio
--      ,SUM(gets) AS gets
--      ,SUM(getmisses) AS misses
FROM v$rowcache
/

PROMPT
PROMPT 2.3 Buffer Cache Hit Ratio
PROMPT ***************************************************************

REM ----------------------------------------------------------------------------
REM In ORACLE 8i and later:
REM                                    Physical Reads -
REM                  (Physical reads direct + Physical reads direct (lob))
REM   Hit Ratio=1 - -------------------------------------------------------
REM                           (DB Block Gets + Consistent Gets -
REM                  (Physical Reads Direct + Physical Reads Direct (lob)))
REM ----------------------------------------------------------------------------

SET SERVEROUTPUT ON
DECLARE
	pr NUMBER;
	prd NUMBER;
	prdl NUMBER;
	dbg NUMBER;
	cg NUMBER;
	hratio NUMBER;
BEGIN
	SELECT value INTO pr FROM v$sysstat WHERE name='physical reads';
	SELECT value INTO prd FROM v$sysstat WHERE name='physical reads direct';
	SELECT value INTO prdl FROM v$sysstat WHERE name='physical reads direct (lob)';
	SELECT value INTO dbg FROM v$sysstat WHERE name='db block gets';
	SELECT value INTO cg FROM v$sysstat WHERE name='consistent gets';
	SELECT TRUNC(100*(1-(pr-(prd+prdl))/(dbg+cg-prd-prdl)),2) INTO hratio FROM dual;
	DBMS_OUTPUT.PUT_LINE('Buffer Cache Hit Ratio: '||hratio||'% (If<70%, increase DB_CACHE_SIZE)');
END;
/

--REM ----------------------------------------------------------------------------
--REM In ORACLE 7,8:
--REM                   Physical Reads
--REM   Hit Ratio=1 - ---------------------------------
--REM                  Consistent Gets + DB Block Gets
--REM ----------------------------------------------------------------------------
--REM
--
--SET SERVEROUTPUT ON
--DECLARE
--	pr NUMBER;
--	dbg NUMBER;
--	cg NUMBER;
--	hratio NUMBER;
--BEGIN
--	SELECT value INTO pr FROM v$sysstat WHERE name='physical reads';
--	SELECT value INTO dbg FROM v$sysstat WHERE name='db block gets';
--	SELECT value INTO cg FROM v$sysstat WHERE name='consistent gets';
--	SELECT TRUNC((1-(pr/(dbg+cg)))*100,2) INTO hratio FROM dual;
--	DBMS_OUTPUT.PUT_LINE('Hit Ratio: '||hratio||'% (If<70%, increase DB_CACHE_SIZE)');
--END;
--/

--COLUMN cachehitratio	FORMAT a30		HEADING 'Buffer Cache Hit Ratio'
--
--SELECT TRUNC((1-(pr.value/(bg.value+cg.value)))*100,2)||'% (If<70%, increase DB_CACHE_SIZE)' AS cachehitratio
--FROM v$sysstat pr
--    ,v$sysstat bg
--    ,v$sysstat cg
--WHERE pr.name='physical reads'
--AND bg.name='db block gets'
--AND cg.name='consistent gets'
--/

PROMPT
PROMPT
PROMPT *******************************************
PROMPT * 3. Contention                           *
PROMPT *    3.1 Disk Physical I/O                *
PROMPT *    3.2 Internal and External Sort       *
PROMPT *    3.3 Rollback Segments Wait Ratio     *
PROMPT *    3.4 Redo Log File Wait               *
PROMPT *******************************************

PROMPT
PROMPT 3.1 Disk Physical I/O
PROMPT ***************************************************************

CREATE OR REPLACE VIEW tot_read_writes 
AS
SELECT SUM(phyrds) phys_reads
      ,SUM(phywrts) phys_wrts
FROM v$filestat
/

COLUMN tablespace_name	FORMAT a20		HEADING 'Tablespace'
COLUMN name		FORMAT a50		HEADING 'Datafile'
COLUMN read_pct		FORMAT 999.99		HEADING 'Reads%'
COLUMN wrts_pct		FORMAT 999.99		HEADING 'Writes%'

SELECT tablespace_name
      ,name
      ,phyrds*100/trw.phys_reads read_pct
      ,phywrts*100/trw.phys_wrts wrts_pct
--      ,phyrds
--      ,phywrts
FROM v$datafile df
    ,v$filestat fs
    ,tot_read_writes trw
    ,dba_data_files ts
WHERE df.file#=fs.file#
AND df.file#=ts.file_id
ORDER BY 1
/

DROP VIEW tot_read_writes
/

PROMPT
PROMPT 3.2 Internal and External Sort
PROMPT ***************************************************************

COLUMN disksortratio	FORMAT a50		HEADING 'Disk Sort Ratio|(If higher, increase SORT_AREA_SIZE)'
COLUMN disksorts  	FORMAT 999,999,999,999	HEADING 'Disk Sorts'
COLUMN memorysorts	FORMAT 999,999,999,999	HEADING 'Memory Sorts'
COLUMN rowssorted 	FORMAT 999,999,999,999	HEADING 'Rows Sorted'

SELECT ROUND(d.value/decode((m.value+d.value),0,1,
            (m.value+d.value))*100)||'%' AS disksortratio
      ,d.value AS disksorts
      ,m.value AS memorysorts     
      ,r.value AS rowssorted
FROM v$sysstat m
    ,v$sysstat d
    ,v$sysstat r
WHERE m.name='sorts (memory)'
AND d.name='sorts (disk)'
AND r.name='sorts (rows)'
/

PROMPT
PROMPT 3.3 Rollback Segments Wait Ratio
PROMPT ***************************************************************

COLUMN rbs FORMAT a20		HEADING 'Rollback Segment'
COLUMN	miss_ratio	FORMAT a40	HEADING 'Wait(Miss) Ratio|(If>1~2%, increase undo segment)'

SELECT name AS rbs
      ,TRUNC(waits/gets*100,2)||'%' AS miss_ratio
FROM v$rollstat
    ,v$rollname
WHERE v$rollstat.usn=v$rollname.usn
ORDER BY miss_ratio asc
/

--REM ----------------------------------------------------------------------------
--REM In RAC:
--REM ----------------------------------------------------------------------------
--

--COLUMN inst	FORMAT 99	HEADING 'Instance#'
--COLUMN rbs	FORMAT a20	HEADING 'Rollback Segment'
--COLUMN mr	FORMAT a50	HEADING 'Wait(Miss) Ratio|(If>1~2%, increase undo segment)'
--
--SELECT v.inst_id AS inst
--      ,d.segment_name AS rbs
--      ,TRUNC(v.waits/v.gets*100,2)||'%' AS mr
--FROM dba_rollback_segs d
--    ,gv$rollstat v
--WHERE d.segment_id=v.usn
--order by mr asc
--/

PROMPT
PROMPT 3.4 Redo Log File Wait (100/Day is good)
PROMPT ***************************************************************

PROMPT - Log File Switch Statistics
PROMPT *******************************************

COLUMN min	FORMAT 999,999,999,999	HEADING 'Min/Day'
COLUMN avg	FORMAT 999,999,999,999	HEADING 'Avg/Day'
COLUMN max	FORMAT 999,999,999,999	HEADING 'Max/Day'

SELECT MIN(cnt) AS min
      ,AVG(cnt) AS avg
      ,MAX(cnt) AS max
FROM (SELECT TO_CHAR(first_time,'yyyymmdd') AS day
            ,COUNT(*) AS cnt
      FROM v$log_history
      WHERE thread#=&thread
      AND TO_CHAR(first_time,'yyyymm')='&yyyymm'
      GROUP BY TO_CHAR(first_time,'yyyymmdd'))
/

PROMPT - Log File Switch Count Per Day
PROMPT *******************************************

SELECT TO_CHAR(first_time,'yyyy-mm-dd') AS day
      ,TO_CHAR(SUM(DECODE(TO_CHAR(first_time,'HH24'),'00',1,0)),'99') AS "00"
      ,TO_CHAR(SUM(DECODE(TO_CHAR(first_time,'HH24'),'01',1,0)),'99') AS "01"
      ,TO_CHAR(SUM(DECODE(TO_CHAR(first_time,'HH24'),'02',1,0)),'99') AS "02"
      ,TO_CHAR(SUM(DECODE(TO_CHAR(first_time,'HH24'),'03',1,0)),'99') AS "03"
      ,TO_CHAR(SUM(DECODE(TO_CHAR(first_time,'HH24'),'04',1,0)),'99') AS "04"
      ,TO_CHAR(SUM(DECODE(TO_CHAR(first_time,'HH24'),'05',1,0)),'99') AS "05"
      ,TO_CHAR(SUM(DECODE(TO_CHAR(first_time,'HH24'),'06',1,0)),'99') AS "06"
      ,TO_CHAR(SUM(DECODE(TO_CHAR(first_time,'HH24'),'07',1,0)),'99') AS "07"
      ,TO_CHAR(SUM(DECODE(TO_CHAR(first_time,'HH24'),'08',1,0)),'99') AS "08"
      ,TO_CHAR(SUM(DECODE(TO_CHAR(first_time,'HH24'),'09',1,0)),'99') AS "09"
      ,TO_CHAR(SUM(DECODE(TO_CHAR(first_time,'HH24'),'10',1,0)),'99') AS "10"
      ,TO_CHAR(SUM(DECODE(TO_CHAR(first_time,'HH24'),'11',1,0)),'99') AS "11"
      ,TO_CHAR(SUM(DECODE(TO_CHAR(first_time,'HH24'),'12',1,0)),'99') AS "12"
      ,TO_CHAR(SUM(DECODE(TO_CHAR(first_time,'HH24'),'13',1,0)),'99') AS "13"
      ,TO_CHAR(SUM(DECODE(TO_CHAR(first_time,'HH24'),'14',1,0)),'99') AS "14"
      ,TO_CHAR(SUM(DECODE(TO_CHAR(first_time,'HH24'),'15',1,0)),'99') AS "15"
      ,TO_CHAR(SUM(DECODE(TO_CHAR(first_time,'HH24'),'16',1,0)),'99') AS "16"
      ,TO_CHAR(SUM(DECODE(TO_CHAR(first_time,'HH24'),'17',1,0)),'99') AS "17"
      ,TO_CHAR(SUM(DECODE(TO_CHAR(first_time,'HH24'),'18',1,0)),'99') AS "18"
      ,TO_CHAR(SUM(DECODE(TO_CHAR(first_time,'HH24'),'19',1,0)),'99') AS "19"
      ,TO_CHAR(SUM(DECODE(TO_CHAR(first_time,'HH24'),'20',1,0)),'99') AS "20"
      ,TO_CHAR(SUM(DECODE(TO_CHAR(first_time,'HH24'),'21',1,0)),'99') AS "21"
      ,TO_CHAR(SUM(DECODE(TO_CHAR(first_time,'HH24'),'22',1,0)),'99') AS "22"
      ,TO_CHAR(SUM(DECODE(TO_CHAR(first_time,'HH24'),'23',1,0)),'99') AS "23"
      ,COUNT(*) AS "Day Sum"
FROM v$log_history
WHERE thread#=&thread
AND TO_CHAR(first_time,'yyyymm')='&yyyymm'
GROUP BY TO_CHAR(first_time,'yyyy-mm-dd')
ORDER BY day DESC
/

PROMPT - Redo Log Space Requests
PROMPT *******************************************

COLUMN name       FORMAT a30	HEADING 'Name'
COLUMN value for 999,999,999 head 'Value|(Near 0 is good, or Increase LOG_BUFFER)'

SELECT 'Redo Log Space Requests' AS name
      ,value
FROM V$SYSSTAT
WHERE name = 'redo log space requests'
/

PROMPT
PROMPT
PROMPT *******************************************
PROMPT * 4. System and Datafile                  *
PROMPT *    4.1 System Free Space                *
PROMPT *    4.2 User Free Space                  *
PROMPT *    4.3 Extents                          *
PROMPT *******************************************

PROMPT
PROMPT 4.1 System Free Space (> 20% is good)
PROMPT ***************************************************************

COLUMN tn       FORMAT a20      	HEADING 'Tablespace'
COLUMN freep    FORMAT a40		   	HEADING 'Free(%)|(If<20%, increase SYSTEM tablespace)'
COLUMN usedp    FORMAT a7			   	HEADING 'Used(%)'
COLUMN bts      FORMAT 999,999		HEADING 'Total|Size(MB)'
COLUMN used     FORMAT 999,999		HEADING 'Used|Size(MB)'
COLUMN free     FORMAT 999,999		HEADING 'Free|Size(MB)'

-- BREAK ON tn SKIP 1 ON REPORT

COMPUTE SUM LABEL 'Subtotal'    OF bts  ON tn
COMPUTE SUM LABEL 'Subtotal'    OF used ON tn
COMPUTE SUM LABEL 'Subtotal'    OF free ON tn
COMPUTE SUM LABEL 'Grand Total' OF bts  ON REPORT
COMPUTE SUM LABEL 'Grand Total' OF used ON REPORT
COMPUTE SUM LABEL 'Grand Total' OF free ON REPORT

SELECT t.tn AS tn
      ,TO_CHAR(TRUNC(((f.fs/t.ts)*100),2))||'%' AS freep
            ,TO_CHAR(TRUNC((((t.ts-f.fs)/t.ts)*100),2))||'%' AS usedp
      ,t.ts AS bts
      ,(t.ts-f.fs) AS used
      ,f.fs AS free
FROM (SELECT tablespace_name AS tn
            ,SUM(bytes/1024/1024) AS ts
      FROM dba_data_files
      GROUP BY tablespace_name) t
    ,(SELECT tablespace_name AS tn
            ,SUM(bytes/1024/1024) AS fs
      FROM dba_free_space
      GROUP BY tablespace_name) f
WHERE t.tn=f.tn(+)
AND t.tn='SYSTEM'
--ORDER BY t.tn
ORDER BY freep DESC
/

PROMPT
PROMPT 4.2 User Free Space (> 20% is good)
PROMPT ***************************************************************

COLUMN tn       FORMAT a20      	HEADING 'Tablespace'
COLUMN freep    FORMAT a50		HEADING 'Free(%)|(If<20%, increase user-defined tablespace)'
COLUMN usedp    FORMAT a7		HEADING 'Used(%)'
COLUMN bts      FORMAT 999,999		HEADING 'Total|Size(MB)'
COLUMN used     FORMAT 999,999		HEADING 'Used|Size(MB)'
COLUMN free     FORMAT 999,999		HEADING 'Free|Size(MB)'

-- BREAK ON tn SKIP 1 ON REPORT

COMPUTE SUM LABEL 'Subtotal'    OF bts  ON tn
COMPUTE SUM LABEL 'Subtotal'    OF used ON tn
COMPUTE SUM LABEL 'Subtotal'    OF free ON tn
COMPUTE SUM LABEL 'Grand Total' OF bts  ON REPORT
COMPUTE SUM LABEL 'Grand Total' OF used ON REPORT
COMPUTE SUM LABEL 'Grand Total' OF free ON REPORT

SELECT t.tn AS tn
      ,TO_CHAR(TRUNC(((f.fs/t.ts)*100),2))||'% ' AS freep
      ,TO_CHAR(TRUNC((((t.ts-f.fs)/t.ts)*100),2))||'%' AS usedp
      ,t.ts AS bts
      ,(t.ts-f.fs) AS used
      ,f.fs AS free
FROM (SELECT tablespace_name AS tn
            ,SUM(bytes/1024/1024) AS ts
      FROM dba_data_files
      GROUP BY tablespace_name) t
    ,(SELECT tablespace_name AS tn
            ,SUM(bytes/1024/1024) AS fs
      FROM dba_free_space
      GROUP BY tablespace_name) f
WHERE t.tn=f.tn(+)
AND t.tn NOT LIKE 'SYSTEM'
--ORDER BY t.tn
ORDER BY freep DESC
/

PROMPT
PROMPT 4.3 Extents (More than 100 Extents or MAX_EXTENTS<10) 
PROMPT ***************************************************************

COLUMN owner		FORMAT a10		HEADING 'Owner'
COLUMN segment_name	FORMAT a50		HEADING 'Segment Name'
COLUMN extents		FORMAT 999,999		HEADING 'Extents'
COLUMN segment_type	FORMAT a15		HEADING 'Segment Type'
COLUMN Size(MB)		FORMAT 999,999		HEADING 'Size(MB)'

SELECT owner||'.'||segment_name AS segment_name
      ,segment_type
      ,extents
      ,max_extents
      ,(bytes/1024/1024) AS "Size(MB)"
FROM dba_segments
WHERE owner NOT IN ( 'SYS'
                    ,'SYSTEM')
AND (max_extents<extents+10 OR extents>100)
ORDER BY owner ASC
        ,extents DESC
/

TTITLE off
CLEAR columns
CLEAR breaks

SET LINESIZE 80
SET PAGESIZE 30

REM SPOOL off

spool off
set markup html off spool off
